<?php
use common\models\PacketCommands;
use backend\models\PacketcommandsSearch;
use yii\helpers\Html;
use kartik\grid\GridView;
use yii\helpers\Url;
use johnitvn\ajaxcrud\CrudAsset;
use yii\bootstrap\Modal;
use common\models\Bots;
use common\models\Commands;

$sModel = new PacketcommandsSearch();
$dProvider = $sModel->search(Yii::$app->request->queryParams);

CrudAsset::register($this);

?>
<?= GridView::widget([
    'dataProvider' => $dProvider,
    'filterModel' => $sModel,
    'pjax' => 'false',
    'tableOptions' => ['class' => 'special_table table-striped table-bordered table-sm'],
    'columns' => [
	    [
	        'attribute'=>'usercommand',
	        'format' => 'raw',
	        'contentOptions' => ['class' => 'usercommand'],
	        'label' => 'Commands sequence',
	        'value' => function($model) {
	        	$res = '<b>'.$model->step.'</b>';
	        	switch ($model->packetcommandtype) {
	        		case 'runbot':
	        			if($model->varname==''){
	        				$res .= '<b> RUN</b>'.' ('.$model->usercommand.')';
	        			}else{
	        				$res .= '<b> LET </b> <i>'.$model->varname.'</i> = '.'<b> RUN </b>'.' ('.$model->usercommand.')';
	        			}
	        			
	        			break;
	        		case 'setvar':
	        			$res .= ' <b>LET</b> <i>'.$model->varname.'</i> = '.$model->varvalue;
	        			break;

	        		case 'ifgoto':
	        			$res .= ' <b>IF</b> <i>'.$model->arg1.'</i> <b>'.strtolower($model->condition).'</b><i> '.$model->arg2.'</i>'.' <b>GO TO </b>'.$model->action;
	        			break;
	        		
	        		case 'ifexit':
	        			$res .= ' <b>IF</b> <i>'.$model->arg1.'</i> <b>'.strtolower($model->condition).'</b><i> '.$model->arg2.'</i>'.' <b>EXIT </b>';
	        			break;
	        		
	        		case 'increment':
	        			$res .= ' <i>'.$model->arg1.'</i> = <i>'.$model->arg1.'</i> + 1';
	        			break;
	        		
	        		case 'decrement':
	        			$res .= ' <i>'.$model->arg1.'</i> = <i>'.$model->arg1.'</i> - 1';
	        			break;
	        		
	        		default:
	        			# code...
	        			break;
	        	}
	        	return $res;
	        }
	    ],
	    [
	        'class' => 'kartik\grid\ActionColumn',
	        'dropdown' => false,
	        'vAlign'=>'middle',
	        'template' => '{update} {delete}',
	        //'template' => '{downloadresult}',
	        'urlCreator' => function($action, $model, $key, $index) { 
	            return Url::to([$action,'id'=>$key]);
	        },
	        
	        
	    ],

    ],
]); 
?>

<?php Modal::begin([
    "id"=>"ajaxCrudModal",
    "footer"=>"",// always need it for jquery plugin
])?>
<?php Modal::end(); ?>
